/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef ALT_UTILS_DIRSTREAM_HH__
#define ALT_UTILS_DIRSTREAM_HH__

#include <iostream>
#include <utils/dirbuf.hh>

namespace alt
{
	//forward definitions
	template <typename charT, typename Traits = std::char_traits<charT> >
	class basic_dirstream;

	//default definitions
	typedef basic_dirstream<char>	dirstream;

	/**
	 * input directory stream
	 */
	template <typename charT, typename Traits>
	class basic_dirstream: public std::basic_istream<charT, Traits>
	{
		typedef charT	char_type;
		typedef Traits	traits_type;
		typedef typename traits_type::int_type	int_type;
		typedef typename traits_type::pos_type	pos_type;
		typedef typename traits_type::off_type	off_type;

		typedef alt::dir_buf<char_type, traits_type> dirbuf_type;
		typedef std::basic_istream<char_type, traits_type> istream_type;
	public:
		basic_dirstream(const char *path):
				istream_type(NULL),
				dirbuf_(path, std::ios_base::in,BUFSIZ)
		{
			this->init(&dirbuf_);
		}
	private:
		dirbuf_type	dirbuf_; /**< internal read buffer */
	};
}

#endif // ALT_UTILS_PSTREAM_HH__
