/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef UTILS_FDSTREAM_HH__
#define UTILS_FDSTREAM_HH__

#include <utils/sysio_filebuf.hh>
#include <iostream>

namespace alt
{
	template <typename charT, typename Traits = std::char_traits<charT> >
		class basic_ifdstream;

	template <typename charT, typename Traits = std::char_traits<charT> >
		class basic_ofdstream;

	typedef basic_ifdstream<char>	ifdstream;
	typedef basic_ofdstream<char>	ofdstream;

	template <typename charT, typename Traits>
		class basic_ifdstream: public std::basic_istream<charT, Traits>
	{
	public:
		typedef charT					char_type;
		typedef Traits					traits_type;
		typedef typename traits_type::int_type		int_type;
		typedef typename traits_type::pos_type		pos_type;
		typedef typename traits_type::off_type		off_type;

		typedef alt::sysio_filebuf<char_type, traits_type> fdbuf_type;
		typedef std::basic_istream<char_type, traits_type> istream_type;

	private:
		fdbuf_type	fdbuf_;

	public:
		basic_ifdstream(int fd,
			std::ios_base::openmode mode = std::ios_base::in)
			: istream_type(NULL), fdbuf_(fd, mode, false, 1)
		{
			this->init(&fdbuf_);
		}
		void close() { fdbuf_.close(); }
	};

	template <typename charT, typename Traits>
		class basic_ofdstream: public std::basic_ostream<charT, Traits>
	{
	public:
		typedef charT					char_type;
		typedef Traits					traits_type;
		typedef typename traits_type::int_type		int_type;
		typedef typename traits_type::pos_type		pos_type;
		typedef typename traits_type::off_type		off_type;

		typedef alt::sysio_filebuf<char_type, traits_type> fdbuf_type;
		typedef std::basic_ostream<char_type, traits_type> ostream_type;

	private:
		fdbuf_type	fdbuf_;

	public:
		basic_ofdstream(int fd,
			std::ios_base::openmode mode = std::ios_base::out)
			: ostream_type(NULL), fdbuf_(fd, mode, false, BUFSIZ)
		{
			this->init(&fdbuf_);
		}
		void close() { fdbuf_.close(); }
	};
}

#endif
