/*
*  ALTerator - ALT Linux configuration project
*
*  Copyright (c) 2004 ALT Linux Ltd.
*  Copyright (c) 2004 Alexey Voinov
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
*  USA.
*/
#ifndef LINE_ITERATOR_HH__
#define LINE_ITERATOR_HH__
#include <iterator>
#include <string>
#include <istream>

namespace alt
{
	class istream_line_iterator
				: public std::iterator < std::input_iterator_tag, std::string,
				ptrdiff_t, const std::string*, const std::string& >
	{
		typedef std::istream istream_type;
	public:
		istream_line_iterator()
				: is_(0)
		{}

		istream_line_iterator(istream_type& is)
				: is_(&is)
		{
			read();
		}

		istream_line_iterator(const istream_line_iterator& o)
				: is_(o.is_), value_(o.value_)
		{}

		const std::string& operator*() const
		{
			return value_;
		}

		const std::string* operator->() const
		{
			return &(operator*());
		}

		istream_line_iterator& operator++()
		{
			read(); return *this;
		}

		istream_line_iterator operator++(int)
		{
			istream_line_iterator tmp = *this;
			read();
			return tmp;
		}

		bool
		operator ==(const istream_line_iterator& o) const
		{
			return is_ == 0 && o.is_ == 0;
		}

		bool
		operator !=(const istream_line_iterator& o) const
		{
			return !operator ==(o);
		}

	private:
		void read(void)
		{
			if (is_ && *is_) std::getline(*is_, value_);
			if (!*is_) is_ = 0;
		}

		istream_type *is_;
		std::string value_;
	};
}

#endif // LINE_ITERATOR_HH__
