/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef UTILS_STR_HH
#define UTILS_STR_HH
#include <string>
#include <iterator>

namespace alt
{
	bool char_before_is_esc(const std::string&, std::string::size_type);
	void remove_esc_before_char(std::string&, std::string::size_type);
	std::string split_on_unescaped_space(std::string&);

	struct args_iterator:
		public std::iterator<std::forward_iterator_tag, const char>
	{
		args_iterator(void) {}
		args_iterator(const std::string& str): str_(str)
		{
			arg_ = split_on_unescaped_space(str_);
		}

		args_iterator& operator ++(void)
		{
			arg_ = split_on_unescaped_space(str_);
			return *this;
		}

		args_iterator operator ++(int)
		{
			args_iterator tmp = *this;
			operator++();
			return tmp;
		}

		const char *operator *(void) const
		{
			return ::strdup(arg_.c_str());
		}

		bool operator == (const args_iterator& o) const
		{
			return str_ == o.str_ && arg_ == o.arg_;
		}

		bool operator != (const args_iterator& o) const
		{
			return !operator==(o);
		}

	private:
		std::string str_;
		std::string arg_;
	};

	std::string trim_left(const std::string&, const char * = " \t");
	std::string trim_right(const std::string&, const char * = " \t");
	std::string trim(const std::string&, const char * = " \t");

	inline
	bool starts_with(const std::string& str, const std::string& start,
			 std::string::size_type pos = 0)
	{
		return str.compare(pos, start.size(), start) == 0;
	}


	inline bool
	starts_with_and_space(const std::string& str, const std::string& start,
			std::string::size_type pos = 0)
	{
		return str.size() >= start.size()
			&& str.compare(pos, start.size(), start) == 0
			&& (str.size() == start.size()
			|| (str.size() > start.size()
				&& (str[start.size()] == ' '
					|| str[start.size()] == '\t')));
	}

}

#endif // UTILS_STR_HH
