/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <utils/guile.hh>
#include <mapper.hh>

scm_mapper::scm_mapper(const std::string& filename): data_(SCM_BOOL_F)
{
	data_ = call(scm::variable_ref("load-mapper"), filename);
	scm_c_define("*mapper*", data_.as_scm());
}

command& list_to_cmd(scm::scm, command&);

command&
scm_mapper::map(const std::string& viewid, command& cmd) const
{
	scm::scm result = call(scm::variable_ref("map-view"), data_, viewid);
	if(!pair_p(result) || null_p(cdr(result))) throw missing();

	return list_to_cmd(result, cmd);
}
