/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <mapper.hh>
//#include <probe_dialog.hh>
#include <iostream>
#include <command_io.hh>

#if 0
bool
process_cmd(const command& cmd, const mapper& m, probe_dialog& d, command_set& c);

void
printp(const std::string& key, const std::string& value)
{
	std::cout << "    <param name=\"" << key
				<< "\" value=\"" << value << "\"/>\n";
}

void
printcmd(const command& c)
{
	std::cout << "  <command name=\"" << c.name() << "\">\n";
	c.for_each(printp);
	std::cout << "  </command>\n";
}

void
printe(const std::string& key, const command& c)
{
	std::cout << "<entry key=\"" << key << "\">\n";
	printcmd(c);
	std::cout << "</entry>\n";
}

struct perform_cmd
{
	perform_cmd(const mapper& m, probe_dialog& d, command_set& c)
		: m_(m), d_(d), c_(c), r_(false) {}

	void operator()(const command& cmd)
	{
		if(r_) return;
		r_ = process_cmd(cmd, m_, d_, c_);
	}

	operator bool() const { return r_; }
private:
	const mapper& m_;
	probe_dialog& d_;
	command_set& c_;
	bool r_;
};

int
main()
{
	mapper m;
	probe_dialog d;
	command_set cmds;

	load_mapper("testmap.xml", m);
	if(process_cmd(command("/ctrl/look")("action", "view")("id", "/"),
				m, d, cmds))
	{
		while(true)
		{
			long result = d.run(std::cout, std::cin);

			if(result >= 0)
			{
				command_set c = cmds;
				if(!c.for_each(result, perform_cmd(m, d, cmds)))
					break;
			}
		}
	}
	return 0;
}
#endif

int main(int argc, char *argv[])
{
	scm::init();
	scm::load(scm::commondir + "mapper.scm");
	if(argc != 2) return 1;

	mapper *m = new scm_mapper("src/prg/map.scm");
	try
	{
		std::cout << (*m)[argv[1]] << std::endl;
	}
	catch(mapper::missing&)
	{
		std::cout << "no such mapping" << std::endl;
	}
	delete m;

	return 0;
}
