/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <libintl.h>
#include <utils/guile.hh>

SCM scm_dgettext(SCM textdomain, SCM msgid)
{
	SCM_ASSERT(SCM_STRINGP(textdomain), textdomain, SCM_ARG1, "dgettext");
	SCM_ASSERT(SCM_STRINGP(msgid), msgid, SCM_ARG2, "dgettext");

	return scm::scm(dgettext(scm::scm(textdomain).as_str().c_str(),
	                         scm::scm(msgid).as_str().c_str())).as_scm();
}

SCM scm_bind_textdomain_codeset(SCM textdomain, SCM codeset)
{
	SCM_ASSERT(SCM_STRINGP(textdomain), textdomain, SCM_ARG1, "dgettext");
	SCM_ASSERT(SCM_STRINGP(codeset), codeset, SCM_ARG2, "dgettext");

	const char *result = bind_textdomain_codeset(scm::scm(textdomain).as_str().c_str(),
	                                             scm::scm(codeset).as_str().c_str());

	return result? scm::scm(result).as_scm() : SCM_BOOL_F;
}

void init_scm_gettext(void)
{
	scm_c_define_gsubr("dgettext", 2, 0, 0,
			   (SCM (*)())scm_dgettext);
	scm_c_define_gsubr("bind-textdomain-codeset", 2, 0, 0,
			   (SCM (*)())scm_bind_textdomain_codeset);
}
