#include <iostream>

#include <glob.h>
#include <utils/guile.hh>

SCM scm_glob(SCM pattern)
{
	SCM_ASSERT(SCM_STRINGP(pattern), pattern, SCM_ARG1, "glob");

	scm::scm result(SCM_EOL);
	glob_t gl;

	if (!glob(scm::scm(pattern).as_str().c_str(),
				GLOB_BRACE|GLOB_NOSORT|GLOB_MARK,NULL,&gl) &&
			gl.gl_pathc)
		for(size_t i=0;i<gl.gl_pathc;i++)
			result = scm::cons(scm::scm(gl.gl_pathv[i]), result);
	globfree(&gl);

	return result.as_scm();
}

void init_scm_glob(void)
{
	scm_c_define_gsubr("glob", 1, 0, 0,(SCM (*)())scm_glob);
}

