(define-macro (delayed . x) `(lambda () ,@x))

(define (make-event name delayed)
  `(event ,name ,delayed))

(define-macro (declare-event name)
  `(define-macro (,name . args)
		  `(make-event (macro-name ,,name) (delayed ,@args))))

(define (sure-symbol x)
  (cond
    ((macro? x) (macro-name x))
    ((symbol? x) x)
    (else "sure-symbol unsupported type for conversion" x)))

(define (make-event-holder)
  (let ((eventmap '()))
    (lambda (command . args)
      (case command
	((call) (let ((founded (assoc (sure-symbol (car args)) eventmap)))
		  (and founded ((cdr founded)))))
	((add)  (set! eventmap (acons (caar args) (cadar args) eventmap)))
	((list) (map car eventmap))
	(else (error "unknown action for event holder" command))))))
