#include <sstream>

#include <qtlook/look.hh>

#include <bus_io.hh>
#include <command_io.hh>

namespace
{
    struct cat_str
    {
	cat_str(std::string& s,const evaluator& e):s_(s), e_(e) {}

	void operator()(const result& item)
	{
	    result r = e_(item);
	    if (!r.is_string()) return;
	    s_ += r.str_;
        }
    
        operator std::string() const { return s_; }
    
	std::string& s_;
	const evaluator& e_;
    };
}

result qtlook_lookup(const std::list<result>& args, const evaluator& eval)
{
    if(args.size() < 3)
		throw eval_error("qtlook_lookup: 2 args expected");

    std::list<result>::const_iterator i = args.begin();
    result ctxt = eval(*i++);

    if(!ctxt.is_string())
		throw eval_error("lookup: context must be string");

    result id = eval(*i++);
    if(!id.is_string())
		throw eval_error("lookup: id must be string");

    result target = eval(*i++);
    if(!target.is_string())
		throw eval_error("lookup: id must be string");

    if ("form" == ctxt.str_)//ask widget
    {
	if (qtlook_dialog::instance().get())
	    return result(qtlook_dialog::instance()->get_attr(id.str_,target.str_));
    }
    else if ("woo" == ctxt.str_)
    {
	//send request
	command question(id.str_);
	question("action","read");
	std::ostringstream sq;
	sq<<question;
	send(">>",sq.str(),std::cin,std::cout,std::cerr);

	command answer;
	//read answer
	while(std::cin)
	{
	    std::string direction;
	    std::getline(std::cin,direction);
	    if ("<<" == direction)
	    {
		std::istringstream ist(receive(std::cin,std::cout,std::cerr));
		ist>>answer;
		break;
	    }
	    else
		std::cout<<"<>"<<std::endl;
	}
	
	return result(answer(target.str_));
    }

    return result("");
}


result qtlook_enlist(const std::list<result>& args, const evaluator& eval)
{
    if(args.size() < 2)
		throw eval_error("qtlook_lookup: 2 args expected");

    std::list<result>::const_iterator i = args.begin();
    result ctxt = eval(*i++);

    if(!ctxt.is_string())
		throw eval_error("lookup: context must be string");

    result target = eval(*i++);
    if(!target.is_string())
		throw eval_error("lookup: id must be string");

    if ("form" == ctxt.str_)//ask widget
    {
    }
    else if ("woo" == ctxt.str_)
    {
	//send request
	command question(target.str_);
	question("action","read");
	std::ostringstream sq;
	sq<<question;
	send(">>",sq.str(),std::cin,std::cout,std::cerr);

	//read answer
	std::ostringstream answer;
	while(std::cin)
	{
	    std::string direction;
	    std::getline(std::cin,direction);
	    if ("<<" == direction)
	    {
		std::istringstream ist(receive(std::cin,std::cout,std::cerr));
		command cmd;
		while (ist>>cmd)
		    answer<<cmd.name().substr(cmd.name().find(target.str_)+target.str_.length()+1,
					      std::string::npos)<<std::endl;
		    std::cerr<<"get:"<<cmd.name()<<std::endl;
		break;
	    }
	    else
		std::cout<<"<>"<<std::endl;
	}
	
	return result(answer.str());
    }

    return result("");
}

result qtlook_cat(const std::list<result>& args, const evaluator& eval)
{
    std::string out;
    return result(std::for_each(args.begin(),args.end(),cat_str(out,eval)));
}
