;there are two levels of abstraction
;1. wrapper over real widget (Qt,Gtk,NDK, etc.)
;2. scheme object for this widget to join with scheme event callbacks

;sample object
(define (make-label event-dispatcher)
  (let ((text "some-text"))
    (lambda (command . args)
      (case command
	((get) text)
	((set) (format #t "setting text~%") (set! text (cadr args)))
	(else (error "unknown operation on label widget" command))))))

;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-widget widget-constructor)
  (let* ((callbacks (make-event-holder))
	 (subwidgets '())
	 (widget (widget-constructor callbacks)))
    (lambda (command . args) ; dispatcher function
      (case command
	((insert) (widget 'insert args))
	((add-event) (callbacks 'add (car args)))
	((get) (widget 'get (car args)))
	((set) (widget 'set (car args) (cadr args)))
	((call) (callbacks 'call (car args))) ;direct call of callbacks
	(else (error "unknown operation on widget" command))))))

;parse widget args during widget creation
(define (widget-parse-args widget arglist)
  (format #t "parsing widget args = ~A~%" arglist)
  widget)

;creates function that parse it's args (there are possible some default args) and return
; a list started with widget symbol
(define-macro (declare-widget name create . attrs)
	      (let ((names (map (lambda (x) (gensym)) attrs))
		    (args (gensym)))
		`(define (,name ,@names . ,args)
		   (let ((widget (make-widget ,create)))
		     ,@(map (lambda (x y)
			      `(widget 'set ,x ,y))
			    attrs names)
		     (list 'widget (widget-parse-args widget ,args))))))

;attribute becomes a function that return it's symbol if it was called without argument (e.g. (text))
;and return a list started with attr symbol if function was calle with attribute value (e.g. (text value))
(define-macro (declare-attribute x)
  (let ((name (gensym)))
    `(define (,x . ,name)
       (if (null? ,name) ',x
	 (list 'attr ',x (car ,name))))))

;declare symbol that refer to itself
(define-macro (declare-keyword x)
  `(define ,x ',x))

