;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (current-dialog) #f) ;current dialog
(define (globals) '()) ; current global parameters for dialog
(define *mapper* #f); current mapper

;fake for mapper
(define (global x) x)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;create dialog object: widget with support of continuation
(define (make-dialog widget-constructor)
  (let ((widget (make-widget widget-constructor))
	(continuation #f))
    (format #t "creating dialog object~%")
    (lambda (command . args)
      (case command
	((set-go) (set! continuation (car args)))
	(else (apply widget command args))))))

;set dialog as a current dialog
(define (set-current-dialog! dlg) (set! current-dialog (lambda () dlg)))

;all work will be with dialog as a current dialog
(define (with-dialog dlg thunk)
  (let ((saved-dlg #f))
    (dynamic-wind
      (lambda ()
	(set! saved-dlg (current-dialog))
	(set-current-dialog! dlg))
      thunk
      (lambda ()
	(set-current-dialog! saved-dlg)))))

;set list as a current globals
(define (set-globals! glist) (set! globals (lambda () glist)))

;all work with be with globals as a current globals
(define (with-globals glist thunk)
  (let ((saved-glist #f))
    (dynamic-wind
      (lambda()
	(set! saved-glist (globals))
	(set-globals! glist))
      thunk
      (lambda()
	(set-globals! glist)))))

;convert path with filename with additional parameters
(define (convert-path mapper uri)
  (let loop ((current-uri uri)
	     (result '()))
    (let ((path (map-view mapper current-uri)))
      (case (list-ref path 2)
	((file) (append (drop path 4) result))
	((view) (loop (sure-string (list-ref path 4)) (append (drop path 5) result)))
	(else (error "unknown action type"))))))

;uri with additional parameters
(define (convert-uri uri)
  (append (convert-path (car uri)) (cdr uri)))
    

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;construct and run dialog from appropriate uri steps:
;1.create new dialog widget
;2.(get uri) <--- with continuation here
;3.(retrieve filename)
;4.(fill-dialog with widget from the file
;5.run-dialog in modal loop

;run with new globals and id's
;TODO: add with IDS
(define (fill-and-run-dialog path dlg)
  (with-globals
    (cdr path)
    (lambda ()
      (format #t "running with globals ~A~%" (globals))
      (format #t "fill and run dialog with path=~A~%" path)
      (format #t "load dialog subwidgets to mainwidget here"))))

(define (run-dialog widget-constructor uri)
  (let ((dlg (make-dialog widget-constructor)))
    (with-dialog dlg
		 (lambda()
		   (fill-and-run-dialog
		     (call-with-current-continuation
		       (lambda (reload)
			 (dlg 'set-go reload)
			 (convert-uri uri)))
		     dlg)))))

