;;;;;;;;;;;;;;;;;;;;;;;;
(define (current-ids) #f)

(define (make-ids-holder)
  (let ((ids '()))
    (lambda (command . args)
      (case command
	((get) (assoc (car args) ids))
	((set) (set! ids (acons (car args) (cadr args) ids)))
	((clear) (for-each
		   (lambda()
		     (eval `(define ,x #f) (current-module)))
		   (map car ids)))
	(else (error "unsupported operation for ids-holder" command))))))


