(define (dynload sym proc handler)
  (let* ((continue #t)
	 (catch-unbound (lambda (sym)
			  (catch 'unbound-variable
				 (lambda() (proc sym))
				 (lambda (key . args) (handler sym continue))))))
    (catch-unbound
      (call-with-current-continuation
	(lambda (exit)
	  (set! continue exit)
	  sym)))))

;(define (test-dynload sym)
;  (dynload sym (lambda (sym)
;	     (format #t "internal routine~%")
;	     (eval sym (current-module)))
;	   (lambda (sym continue)
;	     (format #t "handler~%")
;	     (eval `(define ,sym (lambda () 4)) (current-module))
;	     (continue sym))))

;(format #t "dynload ~A~%" ((test-dynload 'f)))
;(format #t "dynload ~A~%" ((test-dynload 'f)))


