/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef DIALOG_QT_HH
#define DIALOG_QT_HH

#include <string>

#include <qmainwindow.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qprogressbar.h>

#include <libguile.h>

class widget
{
	SCM data_;
public:
	virtual ~widget(void);

	virtual void set_attr(const std::string&, const std::string&) = 0;
	virtual std::string get_attr(const std::string& name) = 0;
	virtual void insert(widget *) =  0;

	void call_event_holder(const std::string&);
	void set_event_holder(SCM data);
};

class qt_widget: public QObject, public widget
{
	Q_OBJECT
public:
	virtual std::string get_attr(const std::string& name);
	virtual void set_attr(const std::string&, const std::string&);
	virtual void insert(widget *);

	virtual QWidget *get_widget(void) const = 0;
public slots:
	void on_click(void);
	void on_change(const QString&);
	void on_change();
	void on_return(void);
	void on_select(void);
	void on_double_click(QListBoxItem*);
};

#define DECLARE_CONSTRUCTOR(name) widget *make_ ## name(void);

#define ATTRIBUTE_FUNCTIONS \
	virtual void set_attr(const std::string&, const std::string&); \
	virtual std::string get_attr(const std::string& name);

#define INSERT_FUNCTIONS \
	virtual void insert(widget *);

#define BEGIN_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
	class qt_##CLASSNAME: public qt_widget \
	{ \
		QTWIDGET *wnd; \
		std::string text_; \
	public: \
		qt_##CLASSNAME(QWidget *parent = 0); \
		virtual QWidget *get_widget(void) const { return wnd; }

#define END_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
	};

#define DECLARE_QT_WIDGET(QTWIDGET,CLASSNAME) \
	BEGIN_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
		ATTRIBUTE_FUNCTIONS \
	END_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
	DECLARE_CONSTRUCTOR(CLASSNAME)

#define DECLARE_QT_CONTAINER(QTWIDGET,CLASSNAME) \
	BEGIN_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
		ATTRIBUTE_FUNCTIONS \
		INSERT_FUNCTIONS \
	END_CLASS_DECLARATION(QTWIDGET,CLASSNAME) \
	DECLARE_CONSTRUCTOR(CLASSNAME)


//single widgets
DECLARE_QT_WIDGET(QPushButton,button)
DECLARE_QT_WIDGET(QLabel,label)
DECLARE_QT_WIDGET(QLineEdit,lineedit)
DECLARE_QT_WIDGET(QTextEdit,textbox)
DECLARE_QT_WIDGET(QCheckBox,checkbox)
DECLARE_QT_WIDGET(QProgressBar,progressbar)

//special for listbox
BEGIN_CLASS_DECLARATION(QListBox,listbox)
	void qt_listbox::set_attr_sub(const std::string&, const std::string&,int);
	ATTRIBUTE_FUNCTIONS
	INSERT_FUNCTIONS
END_CLASS_DECLARATION(QListBox,listbox)

//containters
DECLARE_QT_CONTAINER(QComboBox,combobox)
DECLARE_QT_CONTAINER(QFrame,vbox)
DECLARE_QT_CONTAINER(QFrame,hbox)


#endif // DIALOG_QT_HH
