/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <iostream>
#include <command_io.hh>

template <typename S, typename K>
void split_discard_char(const std::string& str, S s, K k)
{
	std::string::size_type pos = str.find(s);
	if(pos != std::string::npos) k(str.substr(0, pos), str.substr(pos + 1));
	else k(str, "");
}

template <typename S, typename K>
void split_before_char(const std::string& str, S s, K k)
{
	std::string::size_type pos = str.find(s);
	if(pos != std::string::npos) k(str.substr(0, pos), str.substr(pos));
	else k(str, "");
}

template <typename S, typename K>
void split_after_char(const std::string& str, S s, K k)
{
	std::string::size_type pos = str.find(s);
	if(pos != std::string::npos) k(str.substr(0, pos), str.substr(pos));
	else k(str, "");
}

struct add_attr
{
	add_attr(command& cmd): cmd_(cmd) {}
	void operator ()(const std::string& first, const std::string& second)
	{
		cmd_(first, second);
	}
private:
	command& cmd_;
};

int usage(void)
{
	std::cerr << "usage: catcmd <name> [<name>=<value> ...]" << std::endl;
	return -1;
}

int main(int argc, char *argv[])
{
	argv++; argc--;
	if(!argc) return usage();
	command cmd(*argv++); argc--;
	while(argc--)
		split_discard_char(*argv++, '=', add_attr(cmd));
	std::cout << cmd;
	return 0;
}
