/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <iostream>
#include <fstream>
#include <string>

#include <bus_io.hh>

int probe(std::istream& is, std::ostream& os, std::ostream& log)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(buf == "<<" || buf == ">>")
		{
			log	<< "-- new message for \""
				<< buf << "\"" << std::endl;
			send(buf, receive(is, os, log), is, os, log);
		}
		else log << "--invalid address line: \""
			 << buf << "\"" << std::endl;
	}
	return 0;
}

int
main(int argc, char *argv[])
{
	if(argc < 2) return probe(std::cin, std::cout, std::cerr);
	std::ofstream os(argv[1]);
	if(!os) return -1;
	return probe(std::cin, std::cout, os);
}
