(dynamic-call "scm_init_qt_look" (dynamic-link "libguile-qtlook.so"))

;general dispatcher over simple qt-widget
;works with simple qt object with our "assembler" from libquile-qt
(define (qt-widget-dispatcher widget command . args)
  (case command
    ((get-widget) widget)
    ((get) (widget-get-attr widget (sure-string (car args))))
    ((set) (format #t "setting attribute ~S to value ~S~%"
    		(sure-string (car args))
		(sure-string (cadr args)))
    	   (widget-set-attr widget (sure-string (car args))
			    (sure-string (cadr args)))
	   (format #t "attr value is is ~S~%" (widget-get-attr widget (sure-string (car args))))
			    )
    ((insert) (widget-insert widget ((car args) 'get-widget)))
    ((delete) (delete-widget widget)
	      (set! widget #f))
    (else (error "unknown operation for qt widget"))))

;enhanced dispatcher for qt dialog (with start and stop commands)
(define (qt-dialog-dispatcher widget command . args)
  (case command
    ((start) (widget-start widget))
    ((stop) (widget-stop widget))
    (else (apply qt-widget-dispatcher widget command args))))
	 
;create an creator for appropriate qt widget
(define (make-qt-widget constructor . disp)
  (let ((dispatcher (if (null? disp) qt-widget-dispatcher (car disp))))
    ;creator with appropriate constructor
    (lambda (event-dispatcher)
      (let ((widget (constructor event-dispatcher)))
	(widget-set-attr widget "hidden" "no")
	;dispatcher
	(lambda (command . args) (apply dispatcher widget command args))))))

(declare-attribute text)
(declare-attribute width)
(declare-attribute height)

(declare-widget dialog (make-qt-widget dlg-make-dialog qt-dialog-dispatcher))

(declare-widget	vbox	(make-qt-widget dlg-make-vbox))
(declare-widget	label	(make-qt-widget dlg-make-label) text)

