(use-modules (ice-9 debug))

(define datadir "../common/")

(load (string-append datadir "dialog-events.scm"))
(load (string-append datadir "dialog-widgets.scm"))
(load (string-append datadir "dialog-ids.scm"))
(load (string-append datadir "dialog-engine.scm"))
(load (string-append datadir "mapper.scm"))
(load (string-append datadir "str.scm"))

(load (string-append datadir "dialog-qt.scm"))

(define (application thunk)
  (let ((app (make-application (command-line))))
    (dynamic-wind
      (lambda() #t)
      thunk
      (lambda() (delete-application app)))))

(define (main)
  (with-mapper (load-mapper "simplemap.scm")
	       (lambda()
		 (run-dialog (make-qt-widget dlg-make-dialog qt-dialog-dispatcher)
			     (make-qt-widget dlg-make-vbox)
			     '("/")))))

;(define (main)
;  (let* ((dlg (dlg-make-dialog #t))
;         (vb  (dlg-make-vbox #t dlg))
;	 (lbl (dlg-make-label #t vb))
;	 (lbl1 (dlg-make-label #t vb)))
;    
;    (widget-set-attr vb "width" "20")
;    (widget-set-attr vb "height" "20")
;    (widget-set-attr lbl "text" "test")
;    (widget-set-attr lbl1 "text" "test1")
;
;
;    (widget-start dlg)
;    (delete-widget lbl)
;    (widget-start dlg)
;     
;    (write-line "after-start")))
    

(application (lambda () (main)))

