//for debug
#include <iostream>

#include <qtlook/dialog.hh>

using namespace qtlook;

dialog_widget::dialog_widget():
    QWidget(0,"dialog_widget"),
    in_loop_(false)
{}

void dialog_widget::exec()
{
    if (in_loop_) return;

    show();
    clearWFlags( WDestructiveClose );
    
    in_loop_ = true;
    qApp->eventLoop()->enterLoop();//start event loop
}

void dialog_widget::intercept(const std::string& id)
{
    lastaction_ = id;
    stop();
}

void dialog_widget::stop()
{
    if (in_loop_)
    {
        in_loop_ = false;
        qApp->eventLoop()->exitLoop();
    }
}

void dialog_widget::closeEvent (QCloseEvent * e)
{
    //ignore close event
}
