(define (cond-cdr key) (and key (cdr key)))

(define (for-range proc range)
  (define (process-range proc start stop)
    (let loop ((start start)
	       (stop stop))
      (and (<= start stop)
	   (begin (proc start)
		  (loop (+ 1 start) stop)))))
  (let loop ((lst range))
    (and (not (null? lst))
	 (let ((item (car lst)))
	   (if (pair? item)
	     (process-range proc 
			    (car item)
			    (cdr item))
	     (proc item))
	   (loop (cdr lst))))))

(define (with-current-object set-func! get-func object thunk)
  (let ((saved-object #f))
    (dynamic-wind
      (lambda()
	(set! saved-object (get-func))
	(set-func! object))
      thunk
      (lambda()
	(set-func! saved-object)))))
