(define help-path "/usr/share/alterator/help")

(define (help-extract-lang locale)
  (substring locale
	     0
	     (or (string-index locale #\_) (string-length locale))))

(define (find-help-file helpfile lst)
  (find (lambda (path)
	  (access? path R_OK))
	(map (lambda (item)
	       (string-append help-path "/" item "/" helpfile))
	     lst)))


(define (help-try-language helpfile)
  (let ((possible (getenv "LANGUAGE")))
    (and possible
	 (find-help-file helpfile
	   (map help-extract-lang
		(string-split possible #\:))))))

(define (help-try-variable variable helpfile)
  (let ((possible (getenv variable)))
    (and possible
	 (find-help-file helpfile
			 (list (help-extract-lang possible))))))

(define (help-file helpfile)
  (or (help-try-language helpfile)
      (help-try-variable "LC_ALL" helpfile)
      (help-try-variable "LC_MESSAGES" helpfile)
      (help-try-variable "LANG" helpfile)))
