(load (string-append datadir "str.scm"))
(load (string-append datadir "command.scm"))

(define (bridge-book-play filename writer)
  (call-with-input-file
    filename
    (lambda (logfile)
      (let read-loop ((cmd (read logfile)))
	(or (eof-object? cmd)
	    (begin (writer cmd)
		   (read-loop (read logfile))))))))

(define (bridge-book-log cmds write-empty write-cmd)
	(if (null? cmds)
	  (write-empty)
	  (for-each (lambda (x) (write-cmd x)) cmds)))

;todo: also duplicate command to bus
(define (bridge-book-log-forward logfile cmdlist)
  (define (log-command cmd) (write cmd logfile) (newline logfile))
  (define (log-empty) (display ";question: empty" logfile) (newline logfile))
  (bridge-book-log cmdlist log-empty log-command)
  (force-output logfile))

(define (bridge-book-log-backward logfile cmdlist)
  (define (log-command cmd) (display (format #f ";answer: ~S~%" cmd) logfile))
  (define (log-empty) (display ";answer: empty" logfile) (newline logfile))
  (bridge-book-log cmdlist log-empty log-command)
  (force-output logfile))


