(define datadir "../common/")

(load (string-append datadir "pipe.scm"))
(load (string-append datadir "str.scm"))
(load (string-append datadir "woobus.scm"))
(load (string-append datadir "command.scm"))
(load (string-append datadir "command-compat.scm"))
(load (string-append datadir "command-pattern.scm"))

;admirals
(define admirals '())

;process each file in directory
(define (directory-for-each dirname proc initial)
  (let ((dir (opendir dirname)))
    (let loop ((e (readdir dir))
	       (initial initial))
      (cond
	((eof-object? e) (closedir dir) initial)
	((and (not (string=? "." e))
	      (not (string=? ".." e))) (loop (readdir dir) (proc (string-append dirname "/" e) initial)))
	(else (loop (readdir dir) initial))))))

;read initial data from old fashioned admiral (or commander)
(define (read-init-info)
  (let loop ((cmd (read-command))
	     (result '()))
    (if (null? cmd)
      result
      (loop (read-command) (cons cmd result)))))

;convert throw external old fashioned program (admiral/commander)
(define (ask-old-admiral prg cmd ctxt) cmd)

;process old fashioned admiral (or commander)
(define (process-old-admiral prg)
  (define (call-old-init prg)
    (with-input-from-pipe (string-append prg " init") (lambda () (read-init-info))))
  (define (make-old-cmd-pattern cmd)
    (make-command-pattern (map sure-string cmd)))
  (map (lambda (x)
	 (cons (make-old-cmd-pattern x)
	       (lambda (cmd ctxt) (ask-old-admiral prg cmd ctxt))))
       (call-old-init prg)))

;determine admiral type
(define (new-admiral? prg)
  (with-input-from-file prg
			(lambda ()
			  (let ((a (read-char))
				(b (read-char))
				(c (read-char)))
			    (and (char=? a #\")
				 (char=? b #\:)
				 (char=? c #\"))))))


(define (process-admiral name lst)
  (let ((pos (string-index-right name #\.)))
   (if (and pos (string=? (substring name (+ pos 1) (string-length name)) "adm"))
    (cons (process-old-admiral name) lst)
      lst)))

;TODO: load both admirals and rear-admirals here
(define (load-admirals-on-board)
  (directory-for-each "/home/stas/Programming/TLA/alterator-inger/bin" process-admiral '()))

(define admirals (load-admirals-on-board))

;try to find pattern in this admiral set and made conversion
(define (try-convert admiralset was-convert)
  was-convert)

;walk throw all admiralsets and try to made conversion
;if no conversion was made - made trivial conversion
(define (do-convert cmd)
  (if (not (fold try-convert #f admirals))
    (format #t "made trivial transform")))

;sample convert
(for-each do-convert (message->commands (read-bus '<<)))

