#ifndef CACHE_HH
#define CACHE_HH
#include <string>

bool in_cache_p(const std::string& id);
std::string cache_get(const std::string& id);
void cache_remove(const std::string& id);
void cache_add(const std::string& id, const std::string& response);
void cache_reset(void);

bool ignored_id_p(const std::string& id);
void ignore_id(const std::string& id);
void unignore_id(const std::string& id);
void unignore_all(void);

#endif // CACHE_HH
