#include <cache.hh>
#include <map>

namespace
{
	typedef std::map<std::string, std::string> cache_t;
	static cache_t cache;
}

bool in_cache_p(const std::string& id)
{
	cache_t::iterator i = cache.find(id);
	return i != cache.end();
}

std::string cache_get(const std::string& id)
{
	cache_t::iterator i = cache.find(id);
	if(i == cache.end()) throw ;
	return i->second;
}

void cache_remove(const std::string& id)
{
	cache_t::iterator i = cache.find(id);
	if(i != cache.end()) cache.erase(i);
}

void cache_add(const std::string& id, const std::string& response)
{
	cache.insert(make_pair(id, response));
}

void cache_reset(void)
{
	cache.clear();
}
