#include <cache.hh>
#include <set>

namespace
{
	std::set<std::string> ignored;
}

bool ignored_id_p(const std::string& id)
{
	return ignored.find(id) != ignored.end();
}

void ignore_id(const std::string& id)
{
	ignored.insert(id);
}

void unignore_id(const std::string& id)
{
	ignored.erase(id);
}

void unignore_all(void)
{
	ignored.clear();
}
