(load (string-append datadir "pipe.scm"))
(load (string-append datadir "compat-telegraph.scm"))

(define (compat-read-process-answer)
  (read-bus-address (forward-address
		      (cons forward-address
			    (message->commands (read-bus-message))))
		    (backward-address
		      (cons backward-address
			    (message->commands (read-bus-message))))))

(define (compat-empty-default cmd-pair) cmd-pair)

(define (command<->process addr cmd-pair next default)
  (define (with-prefix lst) (cons (car cmd-pair) lst))
  
  (if (write-bus addr (commands->message (cdr cmd-pair)))
    (let ((result (compat-read-process-answer))) ; if message was accepted 'then wait for the answer
      (cond
	((string=? (car result) forward-address)
	 (command<->process '<< (next (with-prefix (cdr result)))
			    next
			    compat-empty-default))
	((string=? (car result) backward-address)
	 (with-prefix (cdr result)))
	(else
	  (error "unknown address:" (car result)))))
  (default cmd-pair)))
      
(define (external-main cmd-pair next)
  (command<->process '>> cmd-pair next 
		    (lambda (cmd-pair)
		      (command<->process '<< (next cmd-pair)
					 next
					 compat-empty-default))))
  
