#!/usr/bin/commander /bin/bash

%. ^/users$ ^action$=^read$
	catcmd /local_users action=read

%. ^/users/(.*)$ ^action$=^read$
	catcmd /local_users/%match:0% action=read

%. ^/users/(.*)$ ^action$=^write$ ^type$=^local$ ^passwd1$=^(.*)$ ^passwd2$=^(.*)$
	if [ "%match:1 " = "%match:2 " ]; then
		catcmd /local_users/%match:0% passwd=%match:2% %attrs:all
	else
		catcmd /error/users/%match:0% action=write reason="passwords mismatch"
	fi

%. ^/users/(.*)$ ^action$=^write$ ^type$=^local$
	catcmd /local_users/%match:0% %attrs:all

%. ^/users/(.*)$ ^action$=^new$ ^type$=^local$ ^passwd1$=^(.*)$ ^passwd2$=^(.*)$
	if [ "%match:1 " = "%match:2 " ]; then
		catcmd /local_users/%match:0% passwd=%match:2% %attrs:all
	else
		catcmd /error/users/%match:0% action=new reason="passwords mismatch"
	fi

%. ^/users/(.*)$ ^action$=^new$ ^type$=^local$
	catcmd /local_users/%match:0% %attrs:all

%. ^/users/(.*)$ ^action$=^delete$ ^type$=^local$
	catcmd /local_users/%match:0% %attrs:all
