/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef DIALOG_HH
#define DIALOG_HH

#include <string>
#include <map>

class widget
{
	std::map<std::string, long> events_;

public:
	virtual ~widget(void);

	virtual widget& set_attr(const std::string&, const std::string&,const std::string& subctrlid = "") = 0;
	virtual std::string get_attr(const std::string& name) = 0;
	virtual widget& insert(widget *) =  0;

	virtual widget& set_event(const std::string&, long);
	virtual long get_event(const std::string&);
};

struct dialog: public widget
{
	virtual ~dialog(void);

	virtual widget *make_button(void) = 0;
	virtual widget *make_label(void) = 0;
	virtual widget *make_lineedit(void) = 0;
	virtual widget *make_textbox(void) = 0;
	virtual widget *make_listbox(void) = 0;
	virtual widget *make_combobox(void) = 0;
	virtual widget *make_checkbox(void) = 0;
	virtual widget *make_progressbar(void) = 0;
	virtual widget *make_vbox(void) = 0;
	virtual widget *make_hbox(void) = 0;

	virtual void name_it(const std::string&, widget *) = 0;
	virtual widget *who_is_it(const std::string&) const = 0;

	virtual long run(void) = 0;
};

#endif // DIALOG_HH
