/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef LOOK_HH
#define LOOK_HH

#include <dialog-new.hh>
#include <mapper.hh>

class look
{
public:
	look(void);
	virtual ~look(void);

	virtual mapper *current_mapper(void) const = 0;
	virtual dialog *current_dialog(void) const = 0;
	virtual bool file(const command&) = 0;
	virtual bool send(const command&) = 0;
	virtual bool error(const command&) = 0;

	virtual bool view(const command&);
	virtual bool attr(const command&);
	virtual bool perform(const command&);
};


#endif // LOOK_HH
