/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <utils/guile.hh>
#include <command.hh>

struct convert_pair
{
	convert_pair(void): result_(SCM_EOL) {}

	void operator ()(const std::string& key, const std::string& value)
	{
		result_ = cons(cons(scm::scm(key), scm::scm(value)), result_);
	}

	operator scm::scm() const
	{
		return result_;
	}

private:
	scm::scm result_;
};

scm::scm cmd_to_list(const command& cmd)
{
	return cmd.for_each(convert_pair());
}
