/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <utils/guile.hh>
#include <command.hh>

// list has following format:
// (cmdname attrname1 attrvalue1 attrname2 attrvalue2 ...)
//
command& list_to_cmd(scm::scm list, command& cmd)
{
	scm::scm prn = scm::variable_ref("display");

	cmd = command();
	if(pair_p(list))
	{
		cmd.name(to_string(car(list), prn).as_str());
		list = cdr(list);
		while(pair_p(list) && pair_p(cdr(list)))
		{
			cmd(to_string(car(list), prn).as_str(),
					to_string(cadr(list), prn).as_str());
			list = cddr(list);
		}
	}
	return cmd;
}
