/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <look.hh>

bool look::view(const command& cmd)
{
	try
	{
		command newcmd;
		current_mapper()->map(cmd("id"), newcmd);
		newcmd.add(cmd, context::keepold);
		return perform(newcmd);
	}
	catch(const mapper::missing&)
	{
		command err(cmd);
		return error(err.name("/error/ctrl/look")
			     ("reason", "no such mapping"));
	}
	catch(const context::missing&)
	{
		command err(cmd);
		return error(err.name("/error/ctrl/look")
			     ("reason", "malformed command (id is missing)"));
	}
	return false;
}

bool look::attr(const command& cmd)
{
	try
	{
		widget *w = current_dialog()->who_is_it(cmd("ctrlid"));
		if(w) w->set_attr(cmd("field"), cmd("value"));
	}
	catch(const context::missing&)
	{
		command err(cmd);
		return error(err.name("/error/ctrl/look")
			     ("reason", "malformed command (id is missing)"));
	}
	return true;
}

bool look::perform(const command& cmd)
{
	if(cmd.name() == "/ctrl/look")
	{
		if(cmd("action") == "file") return file(cmd);
		else if(cmd("action") == "view") return view(cmd);
		else if(cmd("action") == "attr") return attr(cmd);
		else if(cmd("action") == "quit") return false;
		return true;
	}
	return send(cmd);
}
