/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <dialog-scm.hh>

static scm_t_bits dialog_tag;
static scm_t_bits widget_tag;

scm::scm wrap_scm_dialog(dialog *d)
{
	SCM_RETURN_NEWSMOB(dialog_tag, d);
}

scm::scm wrap_scm_widget(widget *w)
{
	SCM_RETURN_NEWSMOB(widget_tag, w);
}

SCM scm_widget_p(SCM widget)
{
	return SCM_SMOB_PREDICATE(widget_tag, widget) ? SCM_BOOL_T : SCM_BOOL_F;
}

SCM scm_widget_insert(SCM w1, SCM w2)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w1) ||
			SCM_SMOB_PREDICATE(dialog_tag, w1),
				w1, SCM_ARG1, "widget-insert");
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w2), w2, SCM_ARG2,
			"widget-insert");

	((widget*)(SCM_SMOB_DATA(w1)))->insert((widget*)(SCM_SMOB_DATA(w2)));

	return w1;
}

SCM scm_widget_set_attr(SCM w, SCM name, SCM value)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w) ||
			SCM_SMOB_PREDICATE(dialog_tag, w),
				w, SCM_ARG1, "widget-set-attr");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "widget-set-attr");
	SCM_ASSERT(SCM_STRINGP(value), value, SCM_ARG3, "widget-set-attr");

	((widget*)(SCM_SMOB_DATA(w)))->set_attr(
			scm::scm(name).as_str(), scm::scm(value).as_str());

	return w;
}

SCM scm_widget_get_attr(SCM w, SCM name)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w) ||
			SCM_SMOB_PREDICATE(dialog_tag, w),
				w, SCM_ARG1, "widget-get-attr");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "widget-get-attr");

	return scm::scm(((widget*)(SCM_SMOB_DATA(w)))->get_attr(
					scm::scm(name).as_str())).as_scm();
}

SCM scm_widget_set_event(SCM w, SCM name, SCM num)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w) ||
			SCM_SMOB_PREDICATE(dialog_tag, w),
				w, SCM_ARG1, "widget-set-event");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "widget-set-event");
	SCM_ASSERT(SCM_INUMP(num), num, SCM_ARG3, "widget-set-event");

	((widget*)(SCM_SMOB_DATA(w)))->set_event(
			scm::scm(name).as_str(), scm::scm(num).as_long());

	return w;
}

SCM scm_widget_get_event(SCM w, SCM name)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w) ||
			SCM_SMOB_PREDICATE(dialog_tag, w),
				w, SCM_ARG1, "widget-get-event");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "widget-get-attr");

	return scm::scm(((widget*)(SCM_SMOB_DATA(w)))->get_attr(
					scm::scm(name).as_str())).as_scm();
}

SCM scm_name_it(SCM d, SCM name, SCM w)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(dialog_tag, d),
		   d, SCM_ARG1, "dlg-name-it");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "dlg-name-it");
	SCM_ASSERT(SCM_SMOB_PREDICATE(widget_tag, w),
		   w, SCM_ARG3, "dlg-name-it");

	((dialog*)(SCM_SMOB_DATA(d)))->name_it(scm::scm(name).as_str(),
					      (widget*)(SCM_SMOB_DATA(w)));

	return w;
}

SCM scm_who_is_it(SCM d, SCM name)
{
	SCM_ASSERT(SCM_SMOB_PREDICATE(dialog_tag, d),
		   d, SCM_ARG1, "dlg-who-is-it");
	SCM_ASSERT(SCM_STRINGP(name), name, SCM_ARG2, "who-is-it");

	return wrap_scm_widget(((dialog*)(SCM_SMOB_DATA(d)))->who_is_it(
				       scm::scm(name).as_str())).as_scm();
}

#define MAKE_WIDGET(name) \
	SCM scm_make_##name(SCM d) { \
		SCM_ASSERT(SCM_SMOB_PREDICATE(dialog_tag, d), d, SCM_ARG1, \
				"dlg-make-" #name); \
		return wrap_scm_widget(\
			((dialog *)SCM_SMOB_DATA(d))->make_##name()).as_scm(); }

MAKE_WIDGET(button)
MAKE_WIDGET(label)
MAKE_WIDGET(lineedit)
MAKE_WIDGET(textbox)
MAKE_WIDGET(listbox)
MAKE_WIDGET(combobox)
MAKE_WIDGET(checkbox)
MAKE_WIDGET(progressbar)
MAKE_WIDGET(vbox)
MAKE_WIDGET(hbox)

void init_scm_dialog(void)
{
	dialog_tag = scm_make_smob_type("dialog", 0);
	widget_tag = scm_make_smob_type("widget", 0);

#define DEFINE_MAKE_WIDGET(name) \
	scm_c_define_gsubr("dlg-make-" #name, 1, 0, 0, \
			(SCM (*)())scm_make_##name)

	DEFINE_MAKE_WIDGET(button);
	DEFINE_MAKE_WIDGET(label);
	DEFINE_MAKE_WIDGET(lineedit);
	DEFINE_MAKE_WIDGET(textbox);
	DEFINE_MAKE_WIDGET(combobox);
	DEFINE_MAKE_WIDGET(listbox);
	DEFINE_MAKE_WIDGET(checkbox);
	DEFINE_MAKE_WIDGET(progressbar);
	DEFINE_MAKE_WIDGET(vbox);
	DEFINE_MAKE_WIDGET(hbox);

#undef DEFINE_MAKE_WIDGET

	scm_c_define_gsubr("widget?", 1, 0, 0,
			   (SCM (*)())scm_widget_p);
	scm_c_define_gsubr("widget-insert", 2, 0, 0,
			   (SCM (*)())scm_widget_insert);
	scm_c_define_gsubr("widget-set-attr", 3, 0, 0,
			   (SCM (*)())scm_widget_set_attr);
	scm_c_define_gsubr("widget-get-attr", 2, 0, 0,
			   (SCM (*)())scm_widget_get_attr);
	scm_c_define_gsubr("widget-set-event", 3, 0, 0,
			   (SCM (*)())scm_widget_set_event);
	scm_c_define_gsubr("widget-get-event", 3, 0, 0,
			   (SCM (*)())scm_widget_get_event);

	scm_c_define_gsubr("dlg-name-it", 3, 0, 0,
			   (SCM (*)())scm_name_it);
	scm_c_define_gsubr("dlg-who-is-it", 2, 0, 0,
			   (SCM (*)())scm_who_is_it);
}
