#include <iostream>
#include <fstream>
#include <map>
#include <list>
#include <string>
#include <stdexcept>

#include <command_io.hh>
#include <bus_io.hh>

struct node
{
    typedef std::list<std::string> child_list;

    node(): root_(true), visited_(false)
    {}

    //fixme: add merging here

    command    cmd_; /**< woobus command */
    bool       root_; /**< flag: are this node without parents */
    bool       visited_; /**< flag: are this node was visited */
    child_list childs_; /**< node childs */
};

typedef std::map<std::string,node> cmd_graph;
typedef std::list<command> cmd_list;

struct tree_walk
{
	tree_walk(cmd_graph& g,std::ostream &os):g_(g),os_(os) {}

	void operator()(const std::string& name)
	{
		node &n = g_[name];
		if (n.visited_) return;
		n.visited_ = true;
		
		if (!n.childs_.empty())
			std::for_each(n.childs_.begin(),
				      n.childs_.end(),
				      tree_walk(g_,os_));
		os_<<n.cmd_;
	}
	private:
		cmd_graph&	g_;
		std::ostream&	os_;
};

struct root_walk
{
	root_walk(cmd_graph& g,std::ostream& os):w_(g,os) {}
	void operator()(const cmd_graph::value_type& v)
	{
		if (v.second.root_) w_(v.first);
	}
	private:
		tree_walk w_;
};

//search string "target" in graph begining search at "start" node
struct graph_search
{
	graph_search(cmd_graph& g,const std::string& t):g_(g),t_(t) {}
	
	bool operator()(const std::string& s)
	{
		node& n = g_[s]; //start node
		if (s == t_) return true;
		else
			return std::find_if(n.childs_.begin(),
		                            n.childs_.end(),
					    graph_search(g_,t_)) != n.childs_.end();
	}
	private:
		cmd_graph& g_;
		const std::string& t_;
};


struct search_cmd
{
	search_cmd(const command& c): c_(c),res_(false) {}

	void operator()(const std::string& name)
	{
		if (res_) return;
		try
		{
			c_(name);
			res_ = true;
		} catch(std::runtime_error&) {}
	}
	operator bool() const { return res_; }

	const command& c_;
	bool res_;
};


bool search_opts(command& cmd1,command& cmd2)
{
	return cmd1.for_each_key(search_cmd(cmd2));
}

void process(std::istream& is,std::ostream& os)
{
	cmd_graph graph;
	
	command curr,prereq,error("/error/");
	while (is>>curr)
	{
		if (!curr.name().empty()) //skip empty commands
		{
			if (graph.find(curr.name()) == graph.end())
			{//create new node
				node n;
				n.cmd_ = curr;
	  			graph[curr.name()] = n;
			}
			else
			{//merge existing node with new
				if (search_opts(graph[curr.name()].cmd_,curr))
				{//check for the same options
					os<<error("reason","option overloading");
					return;
				}
				graph[curr.name()].cmd_.add(curr);
			}

			if (!prereq.name().empty() && (prereq.name() != curr.name()))
			{
				if (graph_search(graph,curr.name())(prereq.name()))
				{
					os<<error("reason","loop was detected on pair "+
							   curr.name()+" with prereq "+prereq.name());
					return;
				}
				graph[curr.name()].childs_.push_back(prereq.name());
				graph[prereq.name()].root_ = false;
			}
		}
		prereq = curr;
	}
	std::for_each(graph.begin(),graph.end(),root_walk(graph,os));
}


int main()
{
	std::ifstream is("cmd.list");
	std::ofstream os("outcmd.list");
	process(is,os);
}
