;transform sequence:
; (define ...
; (defome ...
;into:
; (lambda ()
;   (define ...
;   (lambda ()
;     (define ...
; this allow us to have letrec* like constructions
(define (sandbox-transform-definitions deflist instructions)
  (let loop ((args (reverse deflist))
	     (result `((lambda()
			,@(if (null? instructions) '(#t) instructions)))))
    (if (null? args)
      result
      (loop (cdr args)
	    `((lambda () ,(car args) ,result))))))

;split readed extressions into definitions and other instructions
(define (sandbox-extract-definitions lst)
  (let loop ((lst lst)
	     (defs '())
	     (insts '()))
    (if (null? lst)
      (cons defs insts)
      (let ((item (car lst)))
	(if (and (pair? item)
		 (eq? (car item) 'define))
	  (loop (cdr lst)
		(append defs (list item))
		insts)
	  (loop (cdr lst)
		defs
		(append insts (list item))))))))

;read all s-expressions in file and return all-of-them in linked list
(define (read-file filename)
  (call-with-input-file
    filename
    (lambda(input)
      (let loop ((item (read input))
		 (result '()))
	(if (eof-object? item)
	  result
	  (loop (read input) (append result (list item))))))))

;for future use
(define *sandbox-dangerous* '(with-input-from-file
			       with-output-to-file
			       call-with-input-file
			       call-with-output-file))

(define (sandbox-prepend-dangerous lst)
  (append (map (lambda (x)
		 `(define ,x #f))
	       *sandbox-dangerous*)
	  lst))

;(let ((defs (sandbox-extract-definitions (read-file "test.scm"))))
;  (pretty-print
;    (eval
;      (sandbox-transform-definitions (append (car defs)
;;					     (map (lambda (x)
;						    `(define ,x #f))
;						  *sandbox-dangerous*))
;				     (cdr defs))))
;    (current-module))))
  

