(dynamic-call "scm_init_glob" (dynamic-link "libguile-glob.so"))

;general libraries
(load (string-append datadir "str.scm"))
(load (string-append datadir "command.scm"))
(load (string-append datadir "pipe.scm"))
(load (string-append datadir "compat-command.scm")) ;for non-native external filters

;own sublibraries
(load (string-append datadir "admiral-pattern.scm"))
(load (string-append datadir "admiral-common.scm"))

;execute non-native filter
(define (execute-admiral-filter cmd filename)
  (let ((process (create-process 'read-write filename "convert")))
    (write-command cmd (caddr process))
    (force-output (caddr process))
    (let ((answer (read-command-list (cadr process))))
      (stop-process 'wait process)
      answer)))

;create adapter for filter (external filter)
(define (make-admiral-adapted-filter filename)
  (define (all-strings pattern)
    (map sure-string pattern))
  (define (read-init-data filename)
    (with-input-from-pipe
      `(,filename "init")
      (lambda ()
	(read-command-list))))
  (map (lambda (pattern)
	 (cons (make-admiral-pattern (all-strings pattern))
	       (lambda (ctxt)
		 (execute-admiral-filter (cdr ctxt) filename))))
       (read-init-data filename)))

(define (make-admiral-native-filter filename)
  (define (valid-expr? expr)
    (and (pair? expr) (command? (car expr))))
  (define (precompile-pattern item)
    (let ((pattern (car item))
	  (actions (cdr item)))
      (cons (make-admiral-pattern pattern)
	    (make-admiral-filter 'hoo-command actions))))
  (map precompile-pattern
       (admiral-read-script filename valid-expr?)))

;load all filters into single list
(define (load-admiral-filters directory)
  (define (filter-or-adapter filename)
    (if (admiral-native-filter? filename)
      (make-admiral-native-filter filename)
      (make-admiral-adapted-filter filename)))
  (fold (lambda (filename lst)
	  (format #t "admiral: loading ~A~%" filename)
	  ;or load native script or simulate this action
	  (append lst (list
			(filter-or-adapter filename))))
	'()
	(glob (string-append directory "/*.adm"))))

;try to find in single filter first pattern and eval
(define (admiral-find-and-eval filter cmd)
   (find-and-eval cmd filter
                 (lambda (curr cmd)
                   (admiral-pattern-match? curr cmd))
                 (lambda (match-result cmd action)
		   (action (cons match-result cmd)))))

;collect result from filters
(define (admiral-filter-command cmd admirals)
  (define (cond-append-list lst1 lst2)
    (or
      (and lst2
	   (append lst1 (list lst2)))
      lst1))
  (fold (lambda (filter result)
	  (cond-append-list result
			    (admiral-find-and-eval filter cmd)))
	'()
	admirals))
