(define (cond-car key) (and (pair? key) (car key)))
(define (cond-cadr key) (and (pair? key) (cadr key)))
(define (cond-cdr key) (and (pair? key) (cdr key)))

(define (for-range proc range)
  (define (process-range proc start stop)
    (let loop ((start start)
	       (stop stop))
      (and (<= start stop)
	   (begin (proc start)
		  (loop (+ 1 start) stop)))))
  (let loop ((lst range))
    (and (not (null? lst))
	 (let ((item (car lst)))
	   (if (pair? item)
	     (process-range proc 
			    (car item)
			    (cdr item))
	     (proc item))
	   (loop (cdr lst))))))

(define (with-current-object set-func! get-func object thunk)
  (let ((saved-object #f))
    (dynamic-wind
      (lambda()
	(set! saved-object (get-func))
	(set-func! object))
      thunk
      (lambda()
	(set-func! saved-object)))))

(define (sure-symbol x)
  (cond
    ((macro? x) (macro-name x))
    ((symbol? x) x)
    ((string? x) (string->symbol x))
    (else "sure-symbol unsupported type for conversion" x)))

;as a begin, but return result of 1st expression
(define-macro (begin-1  . expressions)
	      (let ((result (gensym)))
		`(let ((,result ,(car expressions)))
		   (begin
		     ,@(cdr expressions)
		     ,result))))
