;;;
;;; ALTerator - ALT Linux configuration project
;;;
;;; Copyright (c) 2004,2005 ALT Linux Ltd.
;;; Copyright (c) 2004,2005 Stanislav Ievlev
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
;;; USA.
;;;

;simple check that object is valid command: this is a list and number of elements is odd
(define (command? obj)
  (and (list? obj) (odd? (length obj))))

;name of the command
(define (command-name obj) (car obj))

;function for processing all command's options
;calls procedure with to args option's name and option's value
(define (command-for-each proc obj)
  (and (pair? obj)
       (let loop ((options (cdr obj)))
	 (if (not (null? options))
	   (begin (proc (car options) (cadr options))
		  (loop (cddr options)))))))

;find_if in command args
(define (command-find-if pred cmd)
  (call-with-current-continuation
    (lambda (exit)
      (command-for-each
	(lambda (name value)
	  (define result (pred name value))
	  (and result (exit result)))
	cmd)
      #f)))

;fold command args
(define (command-fold proc initial cmd)
  (let loop ((current (cdr cmd))
	     (initial initial))
    (if (null? current)
    	initial
	(loop (cddr current) (proc (car current) (cadr current) initial)))))

;query for some option
(define (command-arg-ref cmd argname)
  (and (command? cmd)
       (command-find-if (lambda (name value)
			  (and (eq? name argname)
			       (cons name value)))
			cmd)))

