;ready for use frame for standalone configurators or control center
(use-translation _translation_ "alterator-common")

;keyword definitions
(declare-keyword number)
(declare-keyword filename)
(declare-keyword stepfile)

;wizard specific events definitions
(declare-event on-next)
(declare-event on-prev)
(declare-event on-apply)

;pass all errors to subwidget handlers
(on-dbus (page 'call on-dbus sender destination interface dmember args))


;enable/disable buttons
(define *dlg-frame-prev-status* 'not-created)
(define *dlg-frame-next-status* 'not-created)

(define (dlg-frame-button-created? variable) (eq? variable 'created))
(define (dlg-frame-button-disabled? variable) (eq? variable 'disabled))

(define (dlg-frame-mark-prev-button) (set! *dlg-frame-prev-status* 'created))
(define (dlg-frame-mark-next-button) (set! *dlg-frame-next-status* 'created))

(define-macro (dlg-frame-enable-common variable widget)
  `(if (dlg-frame-button-created? ,variable)
    (,widget enabled #t)
    (set! ,variable 'enabled)))

(define-macro (dlg-frame-disable-common variable widget)
  `(if (dlg-frame-button-created? ,variable)
    (,widget enabled #f)
    (set! ,variable 'disabled)))

(define (enable-prev) (dlg-frame-enable-common
			*dlg-frame-prev-status*
			prev-button))
(define (enable-next) (dlg-frame-enable-common
			*dlg-frame-next-status*
			next-button))

(define (disable-prev) (dlg-frame-disable-common
			 *dlg-frame-prev-status*
			 prev-button))
(define (disable-next) (dlg-frame-disable-common
			 *dlg-frame-next-status*
			 next-button))

(define (dlg-frame-prev-attr-enabled)
  (enabled (not (dlg-frame-button-disabled? *dlg-frame-prev-status*))))

(define (dlg-frame-next-attr-enabled)
  (enabled (not (dlg-frame-button-disabled? *dlg-frame-next-status*))))

;checks for global wizard parameters
(define (dlg-frame-global-passing?) (not (global filename)))

(define (dlg-frame-real-filename)
  (if (dlg-frame-global-passing?) (global stepfile) (global filename)))

;create internal page
(define (dlg-frame-make-page w h)
  (id 'page (vbox (relative-width w)
		  (relative-height h)
	     (include (dlg-frame-real-filename)))))

;go previous step button
(define (dlg-frame-make-prev-button)
  (begin-1
    (id 'prev-button
	(if (dlg-frame-global-passing?)
	  (button (_translation_ "Exit") (dlg-frame-prev-attr-enabled) (on-click (end-dialog)))
	  (button (_translation_ "Prev") (dlg-frame-prev-attr-enabled) (on-click (page 'call on-prev)))))
    (dlg-frame-mark-prev-button)))

;go next step button
(define (dlg-frame-make-next-button)
  (begin-1
    (id 'next-button
	(if (dlg-frame-global-passing?)
	  (button (_translation_ "Apply") (dlg-frame-next-attr-enabled) (on-click (page 'call on-apply)))
	  (button (_translation_ "Next") (dlg-frame-next-attr-enabled) (on-click (page 'call on-next)))))
    (dlg-frame-mark-next-button)))

;create bottom line with buttons
(define (dlg-frame-make-buttons)
  (hbox margin 2 spacing 1
	(dlg-frame-make-prev-button)
	(dlg-frame-make-next-button)))

;window with internal page and navigation buttons
(define (dlg-frame-make-frame w h)
  (vbox margin 1
    (dlg-frame-make-page w h)
    (dlg-frame-make-buttons)))

