;barnacle - old mariner (old backend format)
;TODO: add with-locked-file
;Note: in this version I've allowed to write to directories.
;Note: 'new action is same as 'write but with exitance checking

(define (error-mariner reason) (lambda args `(error ,reason)))

(define (barnacle script objects action)
  ;helpers
    (define (type-from-answer answer)
    (let ((pos (string-index-right answer #\space)))
      (and pos (string-ref answer (+ 1 pos)))))
  (define (name-from-answer answer)
    (substring answer 0 (or (string-index-right answer #\space) (string-length answer))))
  (define (args-from-answer answer)
    (let ((pos (string-index answer #\:)))
      (if pos
	(cons (substring answer 0 pos)
	      (substring answer (+ pos 1) (string-length answer)))
	(error "wrong answer from backend, : separator not found" answer))))
  ;actions
  (define (do-read-list port)
    (read-fold (lambda (x res) (cons (list (name-from-answer x)) res)) '() port))
  (define (do-read-info port)
    (read-fold (lambda (x res)
		 (let ((splited (args-from-answer x)))
		   (cons (car splited) (cons (cdr splited) res)))) '() port))
  (define (do-in object-name option proc)
    (define (combine process result)
      (cons (stop-process 'wait process) result))
    (let ((process (create-process 'read-only script option object-name)))
      (combine process (proc (cadr process)))))
  (define (do-out object-name . args)
    ;we have made a sigpipe protected output to backend, and , therefore, ignore possible problems 
    ;in backends. it's possible we will return a error message in the future
    (let ((outport (create-process 'write-only script "-w" object-name)))
      (catch #t
	     (lambda ()
	       (with-ignored-sigpipe
		 (lambda ()
		   (and (pair? args)
			(display
			  (string-join
			    (map (lambda (x)
				   (format #f "~A:~A~%" (car x) (cdr x)))
				 (car args))
			    "")
			  (caddr outport)))
		   (stop-process 'wait outport))))
	     (lambda (key . args)
	       (stop-process 'terminate outport)))))
  (define (do-delete object-name)
    (and (not (= 0 (stop-process 'wait (create-process 'read-only script "-d" object-name))))
	 '(error "object was not deleted")))
  (define (do-type object-name)
    (if (string=? object-name "/")
      #\d
      (with-input-from-pipe `(,script "-t" ,object-name)
			    (lambda ()
			      (let ((answer (read-line)))
				(if (eof-object? answer) #f (type-from-answer answer)))))))
  ;dispatcher
  (let ((object-name (string-join (if (null? objects) '("/") objects) "/")))
    (case action
      ((list) (lambda args
		(let ((result (do-in object-name "-l" do-read-list)))
		  (if (= 0 (car result))
		    (cdr result)
		    '(error "list action failed")))))
      ((read) (lambda args
		(let ((result (do-in object-name "-r" do-read-info)))
		  (if (= 0 (car result))
		    (cdr result)
		    '(error "read action failed")))))
      ((write) (lambda args (and (not (= 0 (apply do-out object-name args)))
				 '(error "write action failed"))))
      ((new)  (lambda args (and (not (= 0 (apply do-out object-name args)))
				'(error "object was not created"))))
      ((delete) (lambda args (do-delete object-name)))
      (else (error-mariner "unsupported action type")))))

