(define *old-backend-dir* "/usr/lib/alterator/backend")
(define *new-backend-dir* "/usr/lib/alterator/backend2")
(define *mariners* '()) ;associative list of loaded backends

;ensign sublibraries
(load (string-append datadir "ensign-barnacle.scm"))

;general helpers
(load (string-append datadir "str.scm"))
(load (string-append datadir "algo.scm"))
(load (string-append datadir "pipe.scm"))
(load (string-append datadir "command.scm"))
(load (string-append datadir "sandbox.scm"))


;filter: split command name, convert args to associative list
(define (prepare-cmds cmds)
  (let loop ((result '())
	     (cmds cmds))
    (cond
      ((null? cmds) result)
      ((null? (car cmds)) (loop result (cdr cmds))) ;ignore null commands
      ((not (pair? (car cmds))) (error "invalid command in list"))
      ((eq? (caar cmds) '#{}#) (loop result (cdr cmds))); also ignore empty commands
      (else
	(let ((current (car cmds)))
	  (loop (append result 
			(list (cons (string-split (sure-string (car current)) #\/)
				    (command-fold acons '() current))))
		(cdr cmds)))))))

;input to easy to use lists
(define (in) (prepare-cmds (message->commands (read-bus '>>))))

;default backend for all commands: always answers - "backend not found"
(define (ghost-mariner object action)
  (lambda args  '(error "backend not found")))

(define (null-mariner object action)
  (lambda args #f))

(use-modules (ice-9 pretty-print))

(define (load-midshipman filename)
  (let ((defs (sandbox-extract-definitions (read-file filename))))
    (eval
      (sandbox-transform-definitions (car defs)
				     (cdr defs))
      (current-module))))

;try to load an appropriate backend
;(define (load-mariner sym continue)
(define (load-mariner sym)
  (let ((old-backend (string-append *old-backend-dir* "/" (sure-string sym)))
	(new-backend (string-append *new-backend-dir* "/" (sure-string sym))))
    (cond
      ((eq? sym 'ctrl) null-mariner)
      ((access? new-backend R_OK) (or (load-midshipman new-backend)
				      ghost-mariner))
      ((access? old-backend R_OK) (eval `(lambda (objects action)
					   (barnacle ,old-backend objects action))
					(current-module)))
      (else ghost-mariner))))

(define (remember-mariner sym backend)
  (and backend
       (set! *mariners* (acons sym backend *mariners*)))
  backend)

(define (resolv-name sym)
  (or (cond-cdr (assoc sym *mariners*))
      (remember-mariner sym (load-mariner sym))))

;load low-level backend
(define (call-mariner cmd)
    (let ((name (car cmd))
	(args (cdr cmd)))
    (if (not (null? name))
      (let ((mariner (resolv-name (sure-symbol (car name))))
	    (action  (assoc 'action args)))
	(if action
	  ((mariner (cdr name) (sure-symbol (cdr action))) args)
	  '(error "action field not found" cmd))))))

(define (error-answer? cmd) (and (pair? cmd) (eq? (car cmd) 'error)))

; new-version: process commands from list and autoconvert results
(define (process-commandlist cmd prev)
  (define (out-error name reason)
    `(,(string-append "/error" name) reason ,reason))
  (define (out-command name options)
    `(,name ,@options))
  (let ((name (string-append "/" (string-join (car cmd) "/")))
        (answer (call-mariner cmd)))
    (if answer
      (append prev
              (cond
                ((null? answer)
                 '()); empty answer
                ((error-answer? answer)
                 (list (out-error name (cadr answer))))
                ((and (pair? answer) (pair? (car answer)))
                 (map (lambda (x)
                        (out-command (string-append name "/" (car x)) (cdr x)))
                      answer))
                ((pair? answer)
                 (list (out-command name answer)))
                (else
                  (list (out-error name "unsupported answer type")))))
      prev)))

;main entry point
(define (ensign-main cmd-pair next)
  (next
    (cons (car cmd-pair)
	  (fold
	    process-commandlist
	    '()
	    (prepare-cmds (cdr cmd-pair))))))

(define (ensign) ensign-main)
