;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (current-dialog) #f) ;current dialog
(define (current-globals) '()) ; current global parameters for dialog
(define (current-mapper) #f); current mapper

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;create dialog object: widget with support of continuation and main subwidget
(define (make-dialog widget-constructor parent)
  (let ((widget (make-widget widget-constructor))
	(return-value #f))
    (widget 'new parent) ; all dialogs are without parents
    (lambda (command . args)
      (case command
	((go) (and (car args)
		   (begin
		     (widget 'delete-subwidgets)
		     (set-current-globals! (prepare-globals (cdr (car args))))
		     (set-current-ids! (make-ids-holder))
		     (widget-parse-args widget (include (car (car args)))))))
	((start)  (set! return-value #f)
		  (widget 'start)
		  return-value)
	((stop)   (widget 'stop)
		  (if (not (null? args))
		    (set! return-value (car args))))
	(else (apply widget command args))))))

;set dialog as a current dialog
(define (set-current-dialog! dlg) (set! current-dialog (lambda () dlg)))
(define (with-dialog dlg thunk) (with-current-object set-current-dialog!
						     current-dialog
						     dlg
						     thunk))

;set list as a current globals
(define (set-current-globals! glist) (set! current-globals (lambda () glist)))
(define (with-globals glist thunk) (with-current-object set-current-globals!
							current-globals
							glist thunk))
(define (prepare-globals lst)
  (let loop ((lst lst)
	     (result '()))
    (if (null? lst) result
      (loop (cddr lst)
	    (acons (car lst) (cadr lst) result)))))


(define (set-current-mapper! mapper) (set! current-mapper (lambda () mapper)))
(define (with-mapper mapper thunk) (with-current-object set-current-mapper!
							current-mapper
							mapper thunk))

;convert path with filename with additional parameters
(define (convert-path mapper uri)
  (let loop ((current-uri uri)
	     (result '()))
    (let ((path (mapper-view mapper current-uri)))
      (and path
	   (case (list-ref path 2)
	     ((file) (append (drop path 4) result))
	     ((view) (loop (list-ref path 4) (append (drop path 5) result)))
	     (else (error "unknown action type")))))))


;uri with additional parameters
(define (convert-uri mapper uri)
  (define (cond-append lst1 lst2)
    (and (pair? lst1) (append lst1 lst2)))
  (cond-append (convert-path mapper (car uri)) (cdr uri)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;construct and run dialog from appropriate uri steps:
;1.create new dialog widget
;2.(get uri) <--- with continuation here
;3.(retrieve filename)
;4.(fill-dialog with widget from the file
;5.run-dialog in modal loop

;reload dialog with new content
(define (goto url . args)
;  ((current-dialog) 'stop)
  ((current-dialog) 'go (convert-uri (current-mapper) (cons url args))))


;fill dialog with data and run
(define (fill-and-run-dialog path)
  (and path
       ;first recreate dialog and move it to pos of current dialog if current dialog exists
       (with-ids (make-ids-holder)
		 (lambda ()
		   (with-globals
		     (prepare-globals (cdr path))
		     (lambda ()
		       (widget-parse-args (current-dialog) (include (car path)))
		       ((current-dialog) 'start)))))))

;internal version of run dialog with explicit constructor
(define (int-run-dialog constructor uri parent)
  (let ((dlg (make-dialog constructor parent)))
    (begin-1
      (with-dialog dlg
		   (lambda ()
		     (fill-and-run-dialog (convert-uri (current-mapper) uri))))
      (dlg 'delete))))

;exit current dialog modal loop
(define (end-dialog . args) (apply (current-dialog) 'stop args))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-relative-size value name source-widget)
  `(attr ,name
	 ,(quotient (* value (source-widget 'get name))
		    100)))

(define-macro (relative-width value . args)
  (let ((source-widget (if (null? args) (current-dialog) (car args))))
    `(lambda() (make-relative-size ,value 'width ,source-widget))))

(define-macro (relative-height value . args)
  (let ((source-widget (if (null? args) (current-dialog) (car args))))
    `(lambda() (make-relative-size ,value 'height ,source-widget))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (global x) (cond-cdr (assoc x (current-globals))))

(define (set-global! name value)
  (let ((res (assoc name (current-globals))))
    (if res (set-cdr! res value)
      (set-current-globals! (acons name value (current-globals))))))
