(define-macro (delayed arglist . x) `(lambda (,@arglist) ,@x))

(define (make-event name delayed)
  `(event ,name ,delayed))

(define-macro (declare-event name . arglist)
	      (let ((args (gensym)))
		    `(define-macro (,name . ,args)
				   (let ((func-args ',arglist))
					   `(make-event ',',name (delayed (,@func-args) ,@,args))))))

(define (make-event-holder)
  (let ((eventmap '()))
    (lambda (command . args)
      (case command
	((call) (let ((founded (assoc (sure-symbol (car args)) eventmap)))
		  (if founded (apply (cdr founded) (cdr args)) #t)))
	((add)  (set! eventmap (acons (caar args) (cadar args) eventmap)))
	((list) (map car eventmap))
	(else (error "unknown operation for event holder" command))))))
