(load (string-append datadir "lookout-common.scm"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(declare-attribute widget-id)

;;;;;;;;;;;;;;;;;;;;;;;;
(define (current-ids) #f)

;;;;;;;;;;;;;;;;;;;;;;;;
(define (make-ids-holder)
  (let ((ids '()))
    (lambda (command . args)
      (case command
	((get) (cond-cdr (assoc (car args) ids)))
	((set) (set! ids (acons (car args) (cadr args) ids)))
	((clear) (for-each
		   (lambda()
		     (eval `(define ,x #f) (current-module)))
		   (map car ids)))
	(else (error "unsupported operation for ids-holder" command))))))

(define (set-current-ids! func) (set! current-ids (lambda () func)))

(define (id name widget)
  (define (append-widget-id delayed-proc)
    (lambda (parent)
      (let ((widget (delayed-proc parent)))
	(widget widget-id name)
	widget)))
  ((current-ids) 'set name (cadr widget))
  (eval `(define ,name ((current-ids) 'get ',name)) (current-module))
  (append (take widget 2)
	  (list (append-widget-id (list-ref widget 2)))))

(define (with-ids ids thunk)
  (let ((saved-ids #f))
    (dynamic-wind
      (lambda ()
        (set! saved-ids (current-ids))
        (set-current-ids! ids))
      thunk
      (lambda ()
        (set-current-ids! saved-ids)))))

