(dynamic-call "scm_init_qt_look" (dynamic-link "libguile-qtlook.so"))

;general dispatcher over simple qt-widget
;works with simple qt object with our "assembler" from libquile-qt
(define (qt-widget-dispatcher widget command . args)
  (case command
    ((get) (widget-get-attr widget (sure-string (car args))))
    ((set) (widget-set-attr widget
			    (sure-string (car args))
			    (cadr args)))
    (else (error "unknown operation for qt widget" command))))

;enhanced dispatcher for qt dialog (with start and stop commands)
(define (qt-dialog-dispatcher widget command . args)
  (case command
    ((start) (widget-start widget))
    ((stop) (widget-stop widget))
    (else (apply qt-widget-dispatcher widget command args))))

(define (qt-tabbox-dispatcher widget command . args)
  (case command
    ((set) (let ((subcommand (car args))
		 (subargs (cdr args)))
	     (case subcommand
	       ((tab-panel) (widget-set-extra widget "add-tab"
					      (car subargs) ;label
					      "" ; unused
					      ((cadr subargs) 'get-widget)))
	       ((current) 
	       		(widget-set-attr widget "current" ((car subargs) 'get-widget)))
	       (else
		 (apply qt-widget-dispatcher widget command args)))))
    (else
      (apply qt-widget-dispatcher widget command args))))

;enhanced dipatcher for qt listbox/combobox (with range support)
(define (qt-listbox-dispatcher widget command . args)
  (define (add-item item)
    (widget-set-extra widget "append"
		      (sure-string (if (pair? item) (car item) item))
		      (sure-string (if (pair? item) (cdr item) ""))
		      ""))

  (define (change-item widget attr value number)
    (widget-set-extra widget "edit"
		      (sure-string attr)
		      (sure-string value)
		      number))
  (case command
    ((set) (let ((subcommand (car args))
		 (subargs (cdr args)))
	     (case subcommand
	       ((items) (widget-set-attr widget "remove" 'all)
			(map add-item (car subargs)))
	       ((append-item) (add-item (car subargs)))
	       ((remove) (if (eq? (car subargs) 'all)
			   (widget-set-attr widget "remove" 'all)
			   (for-range (lambda (x) (widget-set-attr widget "remove" x))
				      subargs)))
	       ((item-pixmap) (for-range (lambda (x) (change-item widget "pixmap" (car subargs) x))
					 (cdr subargs)))
	       ((item-text) (for-range (lambda (x) (change-item widget "text" (car subargs) x))
				       (cdr subargs)))
	       (else (widget-set-attr widget 
				      (sure-string subcommand)
				      (car subargs))))))
    ((get) (let ((subcommand (car args))
		 (subargs (cdr args)))
	     (case subcommand
	       ((item-text) (widget-get-extra widget "text" (car subargs)))
	       (else (widget-get-attr widget
				      (sure-string subcommand))))))
    (else (apply qt-widget-dispatcher widget command args))))




;create an creator for appropriate qt widget
(define (make-qt-widget constructor . disp)
  (let ((dispatcher (if (null? disp) qt-widget-dispatcher (car disp))))
    ;creator with appropriate constructor
    (lambda (event-dispatcher)
      (let ((widget #f))
	;dispatcher
	(lambda (command . args)
	  (case command
	    ((get-widget) widget)
	    ((new) (set! widget (constructor event-dispatcher
					     (and (car args) ((car args) 'get-widget))))
		      (widget-set-attr widget "hidden" #f))
	    ((delete) (delete-widget widget)
		      (set! widget #f))
	    (else  (and widget (apply dispatcher widget command args)))))))))

(declare-attribute text)
(declare-attribute text-append)
(declare-attribute editable)
(declare-attribute mask)
(declare-attribute width)
(declare-attribute height)
(declare-attribute default)
(declare-attribute flat)
(declare-attribute font)
(declare-attribute align)
(declare-attribute margin)
(declare-attribute spacing)
(declare-attribute caption)
(declare-attribute echo)
(declare-attribute pixmap)
(declare-attribute backgroundpixmap)
(declare-attribute sizepolicy)
(declare-attribute current)
(declare-attribute readonly)
(declare-attribute enabled)
(declare-attribute checked)
(declare-attribute total)
(declare-attribute value)
(declare-attribute hidden)
(declare-attribute append-item)
(declare-attribute items)
(declare-attribute item-pixmap)
(declare-attribute item-text)
(declare-attribute remove)
(declare-attribute full_screen)
(declare-attribute tab-panel)

(declare-keyword yes)
(declare-keyword no)
(declare-keyword center)
(declare-keyword left)
(declare-keyword right)
(declare-keyword stars)

(declare-event on-click)
(declare-event on-double-click)
(declare-event on-change)
(declare-event on-return)
(declare-event on-select)
(declare-event on-error)
(declare-event on-dbus sender destination interface dmember args)

(declare-widget dialog (make-qt-widget dlg-make-dialog qt-dialog-dispatcher))
(declare-widget button (make-qt-widget dlg-make-button) text)
(declare-widget label (make-qt-widget dlg-make-label) text)
(declare-widget edit (make-qt-widget dlg-make-lineedit) text)
(declare-widget vbox (make-qt-widget dlg-make-vbox))
(declare-widget hbox (make-qt-widget dlg-make-hbox))
(declare-widget checkbox (make-qt-widget dlg-make-checkbox) text)
(declare-widget progressbar (make-qt-widget dlg-make-progressbar))
(declare-widget textbox (make-qt-widget dlg-make-textbox) text)
(declare-widget listbox (make-qt-widget dlg-make-listbox qt-listbox-dispatcher))
(declare-widget combobox (make-qt-widget dlg-make-combobox qt-listbox-dispatcher))
(declare-widget tabbox (make-qt-widget dlg-make-tabbox qt-tabbox-dispatcher))

;wrapper over tab-panel
;insert widgets and generate also tab-panel attribute
(define (tab tab-id tab-label . widgets)
  (let ((vb (id tab-id (apply vbox widgets))))
   `(,vb ,(tab-panel tab-label (cadr vb)))))

(define make-main-dialog (make-qt-widget dlg-make-dialog qt-dialog-dispatcher))

