;general helpers
(dynamic-call "scm_init_glob" (dynamic-link "libguile-glob.so"))
(load (string-append datadir "gettext.scm"))
(load (string-append datadir "help.scm"))
(load (string-append datadir "algo.scm"))
(load (string-append datadir "command.scm"))
(load (string-append datadir "dialog-functions.scm"))
(load (string-append datadir "str.scm"))
(load (string-append datadir "sandbox.scm"))


;lookout sublibraries:
(load (string-append datadir "lookout-ids.scm"))
(load (string-append datadir "lookout-widgets.scm"))
(load (string-append datadir "lookout-engine.scm"))
(load (string-append datadir "lookout-woo.scm"))
(load (string-append datadir "lookout-mapper.scm"))


;load qt specific stuff
(load (string-append datadir "lookout-qt.scm"))

(define (dbus-handler sender destination interface memb_er . args)
  (and (current-dialog)
       ((current-dialog) 'call on-dbus
			 sender
			 destination
			 interface
			 memb_er
			 args)))

(define (application thunk)
  (let ((app (make-application cmdline dbus-handler)))
    (dynamic-wind
      (lambda() #t)
      thunk
      (lambda() (delete-application app)))))

;run new dialog
(define (run-dialog uri . parent)
 (let ((parent-widget (if (null? parent) (current-dialog) (car parent))))
  (int-run-dialog make-main-dialog uri parent-widget)))

;run main dialog
(define (lookout-main filename)
 (with-mapper (load-mapper filename)
	       (lambda()
		 (run-dialog '("/") #f))))

(define (lookout filename)
  (application (lambda() (lookout-main filename))))


