(define-macro (telegraph . args)
  `(define *telegraph*
     (list ,@(map (lambda (x)
		 `(cons ',x ,x))
		 args)))) 

(define *telegraph-forward-hook* #f)
(define *telegraph-backward-hook* #f)

(define (run-telegraph cmd . args)
  (let ((lst (if (null? args) *telegraph* (car args))))
    (if (null? lst)
      cmd
      (begin (and (procedure? *telegraph-forward-hook*)
                  (*telegraph-forward-hook* (caar lst) cmd))
             (let ((call-result ((cdar lst)
                                 cmd
                                 (lambda (cmd) (run-telegraph cmd (cdr lst))))))
               (and (procedure? *telegraph-backward-hook*)
                    (*telegraph-backward-hook* (caar lst) call-result))
               call-result)))))

