/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2004,2005 ALT Linux Ltd.
 *  Copyright (c) 2004,2005 Alexey Voinov
 *  Copyright (c) 2004,2005 Stanislav Ievlev
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef BUS_BUS_HH
#define BUS_BUS_HH
#include <bus/core.hh>
#include <iterator>

struct bus_iterator:
	public std::iterator<std::bidirectional_iterator_tag, woobus::module>
{
	bus_iterator(woobus::module * = 0);

	bus_iterator& operator ++(void);
	bus_iterator& operator --(void);

	bus_iterator operator ++(int)
	{
		bus_iterator tmp = *this;
		operator ++();
		return tmp;
	}

	bus_iterator operator --(int)
	{
		bus_iterator tmp = *this;
		operator --();
		return tmp;
	}

	woobus::module& operator *(void) const { return *current_; }
	woobus::module *operator ->(void) const { return current_; }

	bool operator ==(const bus_iterator& o) const
	{
		return current_ == o.current_;
	}

	bool operator !=(const bus_iterator& o) const
	{
		return !operator ==(o);
	}

private:
	woobus::module *current_;
};

bus_iterator modules_begin(void);
bus_iterator modules_end(void);
void modules_insert(const bus_iterator&, const woobus::module&);
void modules_append(const bus_iterator&, const woobus::module&);
void modules_remove(const bus_iterator&);

template <typename Pred> bus_iterator modules_find(Pred p)
{
	return std::find_if(modules_begin(), modules_end(), p);
}

void bus_finit(void);

#endif // BUS_BUS_HH
